<?php
require_once(dirname(__FILE__).'/config.php');
require_once(dirname(__FILE__).'/Aip/AipNlp.php');
if(empty($cfg_bdqc_appid) || empty($cfg_bdqc_apikey) || empty($cfg_bdqc_arcretkey))
{
	$data = array('code'=>0, 'data'=>'', 'msg'=>'未添加百度分词系统变量');
	if($cfg_soft_lang == 'gb2312')
	{
		$data['msg'] = gb2utf8($data['msg']);
	}
	exit(json_encode($data));
}
$client = new AipNlp($cfg_bdqc_appid, $cfg_bdqc_apikey, $cfg_bdqc_arcretkey);
$lexer = $client->lexer($title);
$tagstr = '';
if(isset($lexer['error_code']))
{
	$data = array('code'=>0, 'data'=>'', 'msg'=>"请检查百度分词API设置：".$lexer['error_msg']);
	if($cfg_soft_lang == 'gb2312')
	{
		$data['msg'] = gb2utf8($data['msg']);
	}
	exit(json_encode($data));
}
if(isset($lexer['items']))
{
	$items = $lexer['items'];
	$qcnum = $cfg_bdqc_qcnum ? $cfg_bdqc_qcnum : rand(1,count($items));
	$itemcount = count($items) > $qcnum ? $qcnum : count($items);
	$result = array_rand($items, $itemcount == 0 ? 1 : $itemcount);
	$resultstr = array();
	if(is_array($result))
	{
		foreach($result as $k => $v)
		{
			$resultstr[] = $items[$v]['item'];
		}
		$tagstr = implode(',', $resultstr);
	}
	else
	{
		$tagstr = $items[$result]['item'];
	}    
}
$data = array('code'=>1, 'data'=>$tagstr, 'msg'=>'分词成功');
if($cfg_soft_lang == 'gb2312')
{
	$data['msg'] = gb2utf8($data['msg']);
}
exit(json_encode($data));